<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

Artisan::command('db:sqlite-to-mysql {--truncate}', function () {
    $tables = [
        'users',
        'staff',
        'services',
        'bookings',
        'booking_service',
        'discounts',
        'schedules',
        'personal_access_tokens',
    ];

    $source = DB::connection('sqlite');
    $target = DB::connection('mysql');

    $target->statement('SET FOREIGN_KEY_CHECKS=0');

    foreach ($tables as $table) {
        if ($this->option('truncate')) {
            $target->table($table)->truncate();
        }

        $rows = $source->table($table)->get();
        $payload = $rows->map(fn ($r) => (array) $r)->all();

        if (count($payload) > 0) {
            foreach (array_chunk($payload, 500) as $chunk) {
                $target->table($table)->insert($chunk);
            }
        }

        $this->line($table.': '.count($payload));
    }

    $target->statement('SET FOREIGN_KEY_CHECKS=1');
})->purpose('Copy data from SQLite (database.sqlite) into MySQL');
