<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\Auth\AuthController as OtpAuthController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\DataController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\DiscountController;

Route::post('/auth/login', [AuthController::class, 'login']);
Route::post('/auth/request-otp', [OtpAuthController::class, 'requestOtp']);
Route::post('/auth/verify-otp', [OtpAuthController::class, 'verifyOtp']);

Route::get('/schedule', [App\Http\Controllers\ScheduleController::class, 'getSchedule']);

Route::get('/data/initial', [DataController::class, 'getInitialData']);

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/auth/logout', [AuthController::class, 'logout']);
    Route::get('/auth/me', [AuthController::class, 'me']);
    Route::put('/auth/update-profile', [AuthController::class, 'updateProfile']);

    // Services CRUD
    Route::get('/services', [App\Http\Controllers\ServiceController::class, 'index']);
    Route::post('/services', [App\Http\Controllers\ServiceController::class, 'store']);
    Route::put('/services/{id}', [App\Http\Controllers\ServiceController::class, 'update']);
    Route::delete('/services/{id}', [App\Http\Controllers\ServiceController::class, 'destroy']);

    // Discounts CRUD
    Route::get('/discounts', [DiscountController::class, 'index']);
    Route::post('/discounts', [DiscountController::class, 'store']);
    Route::put('/discounts/{id}', [DiscountController::class, 'update']);
    Route::delete('/discounts/{id}', [DiscountController::class, 'destroy']);

    Route::get('/bookings', [BookingController::class, 'index']);
    Route::post('/bookings', [BookingController::class, 'store']);
    Route::put('/bookings/{id}', [BookingController::class, 'update']);
    Route::delete('/bookings/{id}', [BookingController::class, 'destroy']);
    Route::post('/schedule', [App\Http\Controllers\ScheduleController::class, 'store']);

    Route::post('/staff', [App\Http\Controllers\StaffController::class, 'store']);
    Route::put('/staff/{id}', [App\Http\Controllers\StaffController::class, 'update']);
    Route::delete('/staff/{id}', [App\Http\Controllers\StaffController::class, 'destroy']);
});
