<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedules', function (Blueprint $table) {
            $table->id();
            $table->string('staff_id')->nullable(); // Null for Global, String for Staff ID
            $table->date('date')->nullable(); // Null for Weekly Template
            $table->integer('day_of_week')->nullable(); // 0-6 (Sun-Sat), Null for Specific Date Override
            $table->json('hours')->nullable(); // ["09:00", "10:00"]
            $table->boolean('is_holiday')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedules');
    }
};
