<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Staff extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'name', 'role', 'specialties', 'avatar_url', 'phone', 'is_vip'];

    protected $casts = [
        'specialties' => 'array',
        'is_vip' => 'boolean',
    ];

    public $incrementing = false;
    protected $keyType = 'string';
}
