<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'id', 'staff_id', 'date', 'time', 
        'payment_type', 'amount_paid', 'customer_phone', 
        'customer_name', 'is_refill', 'salon_id', 'created_at_timestamp'
    ];

    protected $casts = [
        'is_refill' => 'boolean',
    ];

    public $incrementing = false;
    protected $keyType = 'string';

    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    public function services()
    {
        return $this->belongsToMany(Service::class, 'booking_service', 'booking_id', 'service_id');
    }
}
