<?php

namespace App\Lib\Sms;

use Illuminate\Support\Facades\Http;

class Payam034
{
    private $api_key;
    private $verifyTemplateId = "gxm5w9ix555e5eb";
    private $verifyUrl = "https://api2.ippanel.com/api/v1/sms/pattern/normal/send";
    /**
     * Create a new class instance.
     */
    public function __construct()
    {
        $this->api_key = config('services.sms.api_key');
    }

    public function verifyCode($number, $code)
    {
        // dd($this->api_key, $this->verifyUrl, $this->verifyTemplateId);
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            'Accept' => 'text/plain',
            'apikey' => $this->api_key
        ])->post($this->verifyUrl, [
            "code" => $this->verifyTemplateId,
            "sender" => "+985000125475",
            "recipient" => $number,
            "variable" => [
                "code" => $code
            ]
        ]);
        // dd($response->json());
        if ($response['status'] == 200) {
            return $response;
        }
        else {
            return response() ->json([
                'success' => false,
                'message' => $response
            ]);
        }
    }
}
