<?php

namespace App\Http\Controllers;

use App\Models\Discount;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Support\DateHelper;

class DiscountController extends Controller
{
    public function index()
    {
        return response()->json(Discount::all());
    }

    public function store(Request $request)
    {
        if ($request->has('start_date')) {
            $request->merge(['start_date' => DateHelper::toGregorian($request->input('start_date'))]);
        }
        if ($request->has('end_date')) {
            $request->merge(['end_date' => DateHelper::toGregorian($request->input('end_date'))]);
        }
        $data = $request->validate([
            'id' => 'nullable|string',
            'name' => 'required|string',
            'start_date' => 'required|date_format:Y-m-d',
            'end_date' => 'required|date_format:Y-m-d',
            'type' => 'required|string|in:PERCENTAGE,FIXED',
            'value' => 'required|integer',
        ]);

        if (empty($data['id'])) {
            $data['id'] = 'dsc-' . Str::uuid()->toString();
        }

        $discount = Discount::create($data);
        return response()->json($discount, 201);
    }

    public function update(Request $request, $id)
    {
        $discount = Discount::findOrFail($id);
        if ($request->has('start_date')) {
            $request->merge(['start_date' => DateHelper::toGregorian($request->input('start_date'))]);
        }
        if ($request->has('end_date')) {
            $request->merge(['end_date' => DateHelper::toGregorian($request->input('end_date'))]);
        }
        $data = $request->validate([
            'name' => 'sometimes|required|string',
            'start_date' => 'sometimes|required|date_format:Y-m-d',
            'end_date' => 'sometimes|required|date_format:Y-m-d',
            'type' => 'sometimes|required|string|in:PERCENTAGE,FIXED',
            'value' => 'sometimes|required|integer',
        ]);

        $discount->update($data);
        return response()->json($discount);
    }

    public function destroy($id)
    {
        Discount::findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
