<?php

namespace App\Http\Controllers;

use App\Models\Discount;
use App\Models\Service;
use App\Models\Staff;
use Illuminate\Http\Request;

class DataController extends Controller
{
    public function getInitialData()
    {
        return response()->json([
            'services' => Service::all(),
            'staff' => Staff::all(),
            'discounts' => Discount::all(),
            'salon' => [
                'id' => 'salon-1',
                'name' => 'سالن زیبایی الگانس',
                'address' => 'تهران، زعفرانیه، خیابان مقدس اردبیلی',
                'phone' => '۰۲۱-۲۲۰۰۳۳۴۴',
                'imageUrl' => '/images/assets/nails.png',
            ]
        ]);
    }
}
